/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.challenge.challenges.DisappearingBlocksChallenge;
import me.angel.challenges6t4.challenge.challenges.ExplodingMobsChallenge;
import me.angel.challenges6t4.client.ActiveChallengesOverlay;
import me.angel.challenges6t4.client.screen.DisappearingBlocksOptionsScreen;
import me.angel.challenges6t4.client.screen.ExplodingMobsOptionsScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ChallengesScreen
extends class_437 {
    private final class_437 parent;
    private float scrollPosition = 0.0f;
    private boolean isDragging = false;
    private static final int ENTRY_HEIGHT = 32;
    private static final int HEADER_HEIGHT = 50;
    private static final int FOOTER_HEIGHT = 32;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int ENTRY_SPACING = 2;
    private final List<MenuEntry> menuEntries = new ArrayList<MenuEntry>();

    public ChallengesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"challenges6t4.screen.title"));
        this.parent = parent;
        this.initializeEntries();
    }

    private void initializeEntries() {
        this.menuEntries.add(new MenuEntry("=== Block Color Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().equals("cant_touch_green") && !challenge.getId().equals("cant_touch_red")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
        this.menuEntries.add(new MenuEntry("=== Weather/Environmental Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().contains("rain") && !challenge.getId().equals("hot_n_cold")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
        this.menuEntries.add(new MenuEntry("=== Teleportation/Movement Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().contains("tp") && !challenge.getId().contains("swap")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
        this.menuEntries.add(new MenuEntry("=== Special Mechanics Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().contains("discord") && !challenge.getId().contains("mob") && !challenge.getId().contains("katamari") && !challenge.getId().contains("xp") && !challenge.getId().contains("liquids") && !challenge.getId().equals("disappearing_blocks")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
        this.menuEntries.add(new MenuEntry("=== Economy/Purchase Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().contains("microtransactions") && !challenge.getId().contains("buy")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
        this.menuEntries.add(new MenuEntry("=== Misc Challenges ==="));
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            if (!challenge.getId().contains("kill")) continue;
            this.menuEntries.add(new MenuEntry(challenge));
        }
    }

    protected void method_25426() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Disable All"), button -> {
            for (MenuEntry entry : this.menuEntries) {
                if (entry.isCategory || entry.challenge == null || !entry.challenge.isEnabled()) continue;
                entry.challenge.setEnabled(false);
                if (entry.toggleButton == null) continue;
                entry.toggleButton.method_25355((class_2561)class_2561.method_43470((String)"Disabled"));
            }
        }).method_46434(this.field_22789 - 100 - 8, 8, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))), button -> {
            ActiveChallengesOverlay.toggleNotifications();
            button.method_25355((class_2561)class_2561.method_43470((String)("Notifications: " + (ActiveChallengesOverlay.areNotificationsEnabled() ? "ON" : "OFF"))));
        }).method_46434(8, 8, 100, 20).method_46431());
        for (MenuEntry entry : this.menuEntries) {
            if (entry.isCategory || entry.challenge == null) continue;
            int toggleWidth = 60;
            int optionsWidth = 60;
            int spacing = 4;
            entry.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(entry.challenge.isEnabled() ? "Enabled" : "Disabled")), button -> {
                entry.challenge.setEnabled(!entry.challenge.isEnabled());
                button.method_25355((class_2561)class_2561.method_43470((String)(entry.challenge.isEnabled() ? "Enabled" : "Disabled")));
            }).method_46434(0, 0, toggleWidth, 20).method_46431();
            if (!entry.challenge.hasOptions()) continue;
            if (entry.challenge instanceof DisappearingBlocksChallenge) {
                entry.optionsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Options..."), button -> this.field_22787.method_1507((class_437)new DisappearingBlocksOptionsScreen(this, (DisappearingBlocksChallenge)entry.challenge))).method_46434(0, 0, optionsWidth, 20).method_46431();
                continue;
            }
            if (!(entry.challenge instanceof ExplodingMobsChallenge)) continue;
            entry.optionsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Options..."), button -> this.field_22787.method_1507((class_437)new ExplodingMobsOptionsScreen(this, (ExplodingMobsChallenge)entry.challenge))).method_46434(0, 0, optionsWidth, 20).method_46431();
        }
    }

    private int getMaxScroll() {
        return Math.max(0, this.menuEntries.size() * 32 - (this.field_22790 - 50 - 32));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition - (float)(verticalAmount * 10.0)), (float)0.0f, (float)this.getMaxScroll());
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isDragging) {
            int maxScroll = this.getMaxScroll();
            if (maxScroll > 0) {
                float scrollbarHeight = this.field_22790 - 50 - 32;
                float scrollbarTrackHeight = scrollbarHeight - 20.0f;
                float scrollAmount = (float)(deltaY * (double)maxScroll) / scrollbarTrackHeight;
                this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition + scrollAmount), (float)0.0f, (float)maxScroll);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int scrollbarX = this.field_22789 - 6 - 4;
            int scrollbarY = 50;
            int scrollbarHeight = this.field_22790 - 50 - 32;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.isDragging = true;
                return true;
            }
            int y = 50 - (int)this.scrollPosition;
            for (MenuEntry entry : this.menuEntries) {
                if (!entry.isCategory && entry.challenge != null) {
                    if (entry.toggleButton != null) {
                        entry.toggleButton.method_46419(y);
                        if (entry.toggleButton.method_25402(mouseX, mouseY, button)) {
                            return true;
                        }
                    }
                    if (entry.optionsButton != null) {
                        entry.optionsButton.method_46419(y);
                        if (entry.optionsButton.method_25402(mouseX, mouseY, button)) {
                            return true;
                        }
                    }
                }
                y += 32;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(0, 50, this.field_22789, this.field_22790 - 32);
        MenuEntry hoveredEntry = null;
        int hoveredY = 0;
        int y = 50 - (int)this.scrollPosition;
        int index = 0;
        for (MenuEntry entry : this.menuEntries) {
            if (y + 32 >= 50 && y <= this.field_22790 - 32) {
                int centerX = this.field_22789 / 2;
                int fullWidth = Math.max(300, this.field_22793.method_1727(entry.isCategory ? entry.categoryName : entry.challenge.getName().getString()) + 60);
                int entryX = centerX - fullWidth / 2;
                if (entry.isCategory) {
                    int lineY = y + 16;
                    int lineColor = -11184811;
                    int textWidth = this.field_22793.method_1727(entry.categoryName);
                    int lineWidth = (fullWidth - textWidth - 20) / 2;
                    context.method_25294(entryX, lineY, entryX + lineWidth, lineY + 1, lineColor);
                    context.method_25294(entryX + fullWidth - lineWidth, lineY, entryX + fullWidth, lineY + 1, lineColor);
                    class_5250 class_52502 = class_2561.method_43470((String)entry.categoryName);
                    int n = this.field_22789 / 2;
                    Objects.requireNonNull(this.field_22793);
                    context.method_27534(this.field_22793, (class_2561)class_52502, n, y + (32 - 9) / 2, 0xFFFF55);
                } else {
                    int backgroundColor;
                    boolean isHovered = mouseY >= y && mouseY <= y + 32 && mouseX >= entryX && mouseX <= entryX + fullWidth;
                    int n = backgroundColor = index % 2 == 0 ? 0x30000000 : 0x30FFFFFF;
                    if (isHovered) {
                        backgroundColor = -2144325377;
                        hoveredEntry = entry;
                        hoveredY = y;
                    }
                    context.method_25294(entryX, y, entryX + fullWidth, y + 32 - 2, backgroundColor);
                    context.method_25294(entryX, y + 32 - 2, entryX + fullWidth, y + 32 - 1, 0x20FFFFFF);
                    if (entry.toggleButton != null) {
                        entry.toggleButton.method_46421(entryX + fullWidth - 64);
                        entry.toggleButton.method_46419(y + 6);
                        entry.toggleButton.method_25394(context, mouseX, mouseY, delta);
                    }
                    if (entry.optionsButton != null) {
                        entry.optionsButton.method_46421(entryX + fullWidth - 130);
                        entry.optionsButton.method_46419(y + 6);
                        entry.optionsButton.method_25394(context, mouseX, mouseY, delta);
                    }
                    class_2561 class_25612 = entry.challenge.getDisplayName();
                    Objects.requireNonNull(this.field_22793);
                    context.method_27535(this.field_22793, class_25612, entryX + 8, y + (32 - 9) / 2, 0xFFFFFF);
                }
            }
            y += 32;
            if (entry.isCategory) continue;
            ++index;
        }
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollbarX = this.field_22789 - 6 - 4;
            int scrollbarY = 50;
            int scrollbarHeight = this.field_22790 - 50 - 32;
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, 0x33FFFFFF);
            float scrollProgress = this.scrollPosition / (float)maxScroll;
            int handleHeight = Math.max(20, (int)((float)scrollbarHeight * (float)scrollbarHeight / (float)(scrollbarHeight + maxScroll)));
            int handleY = scrollbarY + (int)((float)(scrollbarHeight - handleHeight) * scrollProgress);
            context.method_25294(scrollbarX, handleY, scrollbarX + 6, handleY + handleHeight, this.isDragging ? -1 : 0x77FFFFFF);
        }
        context.method_44380();
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        if (hoveredEntry != null && hoveredEntry.challenge != null) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(hoveredEntry.challenge.getDescription());
            if (hoveredEntry.challenge.hasOptions()) {
                tooltip.add(class_2561.method_43470((String)"\u00a77Click Options to configure"));
            }
            context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    private static class MenuEntry {
        final Challenge challenge;
        final boolean isCategory;
        final String categoryName;
        class_4185 toggleButton;
        class_4185 optionsButton;

        MenuEntry(String categoryName) {
            this.categoryName = categoryName;
            this.isCategory = true;
            this.challenge = null;
        }

        MenuEntry(Challenge challenge) {
            this.challenge = challenge;
            this.isCategory = false;
            this.categoryName = null;
        }
    }
}

